/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.property.PropertySupport;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.RebuildType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class Workplace
implements Propertized {
    private final String name;
    private final Set<String> capabilities;
    private final Set<RebuildType> rebuildTypes;
    private final Map<String, RebuildType> rebuildTypesMap;
    private final boolean cumulative;
    private final String description;
    private final PropertySupport propertySupport;

    private Workplace(Builder bob) {
        Preconditions.checkNotNull(bob.name, "Workplace name cannot be null.");
        Preconditions.checkNotNull(bob.description, "Workplace description cannot be null.");
        Preconditions.checkState(bob.capabilities.size() > 0, "Workplace must have at least one capability.");
        this.name = bob.name;
        this.capabilities = bob.capabilities;
        this.rebuildTypes = bob.rebuildTypes;
        this.rebuildTypesMap = Maps.newHashMap();
        this.cumulative = bob.cumulative;
        this.description = bob.description;
        this.propertySupport = new PropertySupport();
        for (RebuildType rt : bob.rebuildTypes) {
            this.rebuildTypesMap.put(rt.getName(), rt);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.name;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public boolean hasCapability(String capability) {
        return this.capabilities.contains(capability);
    }

    public String toString() {
        return "Workplace(name=" + this.name + ")";
    }

    public boolean isCumulative() {
        return this.cumulative;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public Set<RebuildType> getRebuildTypes() {
        return this.rebuildTypes;
    }

    @Deprecated
    public long getRebuildTime(Action a) throws IllegalArgumentException {
        String type = a.getRebuildType();
        RebuildType art = this.getRebuildType(type);
        if (art == null) {
            throw new IllegalArgumentException(String.format("Workplace %s does not contain rebuild type %s of action %s of product %s.", this.getName(), type, a.getName(), a.getProduct().getName()));
        }
        return art.getTime();
    }

    public RebuildType getRebuildType(String name) {
        Preconditions.checkNotNull(name);
        return this.rebuildTypesMap.get(name);
    }

    public long getMaxRebuildTime() {
        long maxRt = Long.MIN_VALUE;
        for (RebuildType rt : this.rebuildTypes) {
            if (rt.getTime() <= maxRt) continue;
            maxRt = rt.getTime();
        }
        return maxRt;
    }

    @Override
    public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.propertySupport.setProperties(this.getClass(), properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.propertySupport.resetProperties(this.getClass(), properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.propertySupport.setProperty(this.getClass(), pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.propertySupport.getProperty(this.getClass(), def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.propertySupport.getProperties();
    }

    public static class Builder {
        private String name;
        private boolean cumulative;
        private String description;
        private Set<String> capabilities;
        private Set<RebuildType> rebuildTypes;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.name = null;
            this.cumulative = false;
            this.description = "";
            this.capabilities = Sets.newHashSet();
            this.rebuildTypes = Sets.newTreeSet(RebuildType.nameComparator());
        }

        public void updateFrom(Workplace workplace) {
            this.name = workplace.getName();
            this.cumulative = workplace.isCumulative();
            this.description = workplace.getDescription();
            this.capabilities = Sets.newHashSet(workplace.getCapabilities());
            this.rebuildTypes = Sets.newTreeSet(RebuildType.nameComparator());
            this.rebuildTypes.addAll(workplace.getRebuildTypes());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCumulative() {
            return this.cumulative;
        }

        public void setCumulative(boolean cumulative) {
            this.cumulative = cumulative;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Set<String> getCapabilities() {
            return Collections.unmodifiableSet(this.capabilities);
        }

        public void addCapability(String cap) {
            Preconditions.checkNotNull(cap);
            Preconditions.checkArgument(!cap.isEmpty());
            this.capabilities.add(cap);
        }

        public void addCapabilities(Collection<String> caps) {
            Preconditions.checkNotNull(caps);
            for (String cap : caps) {
                this.addCapability(cap);
            }
        }

        public Set<RebuildType> getRebuildTypes() {
            return Collections.unmodifiableSet(this.rebuildTypes);
        }

        public boolean addRebuildType(RebuildType rt) {
            Preconditions.checkNotNull(rt);
            return this.rebuildTypes.add(rt);
        }

        public boolean addRebuildTypes(Collection<RebuildType> rebs) {
            Preconditions.checkNotNull(rebs);
            boolean res = true;
            for (RebuildType rt : rebs) {
                if (this.addRebuildType(rt)) continue;
                res = false;
            }
            return res;
        }

        public Workplace build() {
            return new Workplace(this);
        }
    }
}

